package com.agilex.healthcare.directscheduling.mdws.connection;

public class SchedulingConnectionManagerFactory {
	private static final org.apache.commons.logging.Log logger = org.apache.commons.logging.LogFactory.getLog(SchedulingConnectionManagerFactory.class);

	private static SchedulingConnectionManager connectionManager;
	private static PoolConfiguration poolConfiguration;

	private SchedulingConnectionManagerFactory() {}

	public static SchedulingConnectionManager getInstance() {
		if (connectionManager != null)
			return connectionManager;

		if (poolConfiguration == null)
			getConfiguration();

		connectionManager = new BasicSchedulingConnectionManager();
		return connectionManager;
	}

	private static PoolConfiguration getConfiguration() {
		if (poolConfiguration == null) {
			logger.debug("Loading connection pool configuration");
			poolConfiguration = new PoolConfiguration();
			poolConfiguration.load();
		}
		return poolConfiguration;
	}
}
